#include <iostream>
#include <algorithm>
#include <vector>
#include <queue>

using namespace std;

const int N = 3601;
vector<int> G[N];
int dist[N];

int main() {
	int T;
	cin >> T;
	
	for(int sd = 0; sd < T; ++sd) {
		fill(dist, dist + N, -1);
		for(int v = 0; v < N; ++v) G[v].clear();

		int n, t;
		cin >> n >> t;
		
		for(int i = 0; i < n; ++i) {
			int b;
			cin >> b;
			for(int v = 0; v < N; ++v) {
				int x = v + b;
				if(x < 0) x = 0;
				if(x >= N) x = N - 1;
				G[v].push_back(x);
			}
		}
		
		queue<int> Q;
		Q.push(0);
		dist[0] = 0;
		
		while(!Q.empty()) {
			int v = Q.front();
			Q.pop();
			for(int x : G[v]) {
				if(dist[x] != -1) continue;
				dist[x] = dist[v] + 1;
				Q.push(x);
			}
		}
		
		int x = t;
		while(x < N) {
			if(dist[x] != -1) {
				cout << dist[x] << " " << x - t << "\n";
				break;
			}
			++x;
		}
	}
	
	return 0;
}
